<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
require_once '../includes/db_connect.php';
require_once '../includes/functions.php';

$error = '';
$debug_info = '';

function add_debug($message) {
    global $debug_info;
    $debug_info .= $message . "<br>";
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = sanitize_input($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    add_debug("Login attempt with username: " . $username);

    if (empty($username) || empty($password)) {
        $error = "Please enter both username and password.";
    } else {
        $sql = "SELECT id, username, password FROM admin_users WHERE username = ?";
        
        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("s", $username);
            
            if ($stmt->execute()) {
                $stmt->store_result();
                
                if ($stmt->num_rows == 1) {
                    $stmt->bind_result($id, $db_username, $hashed_password);
                    if ($stmt->fetch()) {
                        add_debug("Stored hashed password: " . $hashed_password);
                        add_debug("Entered password: " . $password);
                        
                        if (password_verify($password, $hashed_password)) {
                            add_debug("Password verified successfully");
                            $_SESSION["admin_id"] = $id;
                            $_SESSION["admin_username"] = $db_username;
                            redirect("index.php");
                        } else {
                            $error = "Invalid username or password.";
                            add_debug("Password verification failed");
                        }
                    }
                } else {
                    $error = "Invalid username or password.";
                    add_debug("Username not found in database");
                }
            } else {
                $error = "Oops! Something went wrong. Please try again later.";
                add_debug("Error executing SQL statement: " . $stmt->error);
            }

            $stmt->close();
        } else {
            $error = "Oops! Something went wrong with preparing the statement.";
            add_debug("Error preparing SQL statement: " . $conn->error);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Forex EA Store</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h2 class="text-center">Admin Login</h2>
                    </div>
                    <div class="card-body">
                        <?php
                        if (!empty($error)) {
                            echo '<div class="alert alert-danger">' . $error . '</div>';
                        }
                        ?>
                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" name="username" id="username" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" name="password" id="password" class="form-control" required>
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Login</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php
    if (!empty($debug_info)) {
        echo '<div class="container mt-5"><div class="alert alert-info">';
        echo '<h4>Debug Information:</h4>';
        echo $debug_info;
        echo '</div></div>';
    }
    ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<?php
$conn->close();
?>