<?php
// Include the database connection
require_once 'includes/db_connect.php';

// Fetch all products
$sql = "SELECT id, name, description, price, image_path FROM products ORDER BY created_at DESC";
$result = $conn->query($sql);

// Set the page title
$pageTitle = "Welcome to Forex EA Store";

// Include the header
include 'includes/header.php';
?>

<div class="container mt-5">
    <div class="jumbotron bg-light p-5 rounded">
        <h1 class="display-4">Welcome to Forex EA Store</h1>
        <p class="lead">Discover high-performance Expert Advisors to elevate your Forex trading strategy.</p>
        <hr class="my-4">
        <p>Explore our collection of automated trading solutions designed to optimize your trading experience.</p>
        <a class="btn btn-primary btn-lg" href="#products" role="button">View Our Products</a>
    </div>

    <section id="products" class="my-5">
        <h2 class="text-center mb-4">Our Expert Advisors</h2>
        <div class="row row-cols-1 row-cols-md-3 g-4">
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $imagePath = $row["image_path"] ? htmlspecialchars($row["image_path"]) : 'path/to/default/image.jpg';
                    ?>
                    <div class="col">
                        <div class="card h-100 shadow-sm">
                            <img src="<?php echo $imagePath; ?>" class="card-img-top" alt="<?php echo htmlspecialchars($row["name"]); ?>" style="height: 200px; object-fit: cover;">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title"><?php echo htmlspecialchars($row["name"]); ?></h5>
                                <p class="card-text flex-grow-1"><?php echo htmlspecialchars(substr($row["description"], 0, 100)) . '...'; ?></p>
                                <div class="d-flex justify-content-between align-items-center mt-3">
                                    <span class="h5 mb-0">$<?php echo number_format($row["price"], 2); ?></span>
                                    <a href="product-details.php?id=<?php echo $row["id"]; ?>" class="btn btn-primary">View Details</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
            } else {
                echo "<p class='text-center'>No products available at the moment.</p>";
            }
            ?>
        </div>
    </section>


    <section class="why-choose-us my-5">
        <h2 class="text-center mb-4">Why Choose Our Expert Advisors?</h2>
        <div class="row">
            <div class="col-md-4">
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <h3 class="card-title">High Performance</h3>
                        <p class="card-text">Our EAs are optimized for maximum efficiency and performance in various market conditions.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <h3 class="card-title">Easy to Use</h3>
                        <p class="card-text">Simple installation and setup process, with detailed documentation for each Expert Advisor.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-4 shadow-sm">
                    <div class="card-body">
                        <h3 class="card-title">Continuous Support</h3>
                        <p class="card-text">Our team provides ongoing support and updates to ensure your EA remains effective.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php
// Close the database connection
$conn->close();

// Include the footer
include 'includes/footer.php';
?>