<?php
require_once 'includes/db_connect.php';

// Enable error reporting for MySQL issues
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Check if product ID is provided and valid
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: products.php");
    exit();
}

$product_id = intval($_GET['id']); // Convert to integer

// Fetch product details including image path
$sql = "SELECT id, name, description, price, image_path FROM products WHERE id = ?";
$stmt = $conn->prepare($sql);

// Check if the statement preparation failed
if (!$stmt) {
    die("Query preparation failed: " . $conn->error);
}

$stmt->bind_param("i", $product_id);

// Execute query
if ($stmt->execute()) {
    echo "Query executed successfully.<br>";
} else {
    echo "Query execution failed: " . $stmt->error . "<br>";
}

// Bind result variables
$stmt->bind_result($id, $name, $description, $price, $image_path);

// Fetch the result
if ($stmt->fetch()) {
    // Data is available
    $product = [
        'id' => $id,
        'name' => $name,
        'description' => $description,
        'price' => $price,
        'image_path' => $image_path
    ];
} else {
    // No data found
    echo "No product found with ID: " . $product_id;
    $product = null;
}

$stmt->close();
$conn->close();

// Check if the product data was retrieved
if ($product === null) {
    exit();
}

// Set the page title based on the product name
$pageTitle = htmlspecialchars($product['name']) . " - Forex EA Store";
include 'includes/header.php';
?>

<!-- Display product details -->
<div class="container mt-5">
    <div class="row">
        <div class="col-md-6">
            <?php if (!empty($product['image_path'])): ?>
                <img src="uploads/<?php echo htmlspecialchars($product['image_path']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="img-fluid">
            <?php else: ?>
                <img src="assets/images/placeholder.jpg" alt="No Image Available" class="img-fluid">
            <?php endif; ?>
        </div>
        <div class="col-md-6">
            <h1><?php echo htmlspecialchars($product['name']); ?></h1>
            <p class="lead"><?php echo htmlspecialchars($product['description']); ?></p>
            <h2 class="mt-4">$<?php echo number_format($product['price'], 2); ?></h2>
            <form action="cart.php" method="post" class="mt-4">
                <input type="hidden" name="product_id" value="<?php echo $product['id']; ?>">
                <input type="hidden" name="action" value="add">
                <button type="submit" class="btn btn-primary btn-lg">Add to Cart</button>
            </form>
        </div>
    </div>
</div>

<?php
include 'includes/footer.php';
?>
