<?php
// Include the database connection
require_once 'includes/db_connect.php';

// Fetch featured products (you might want to add a 'featured' column in your database)
$sql = "SELECT id, name, description, price FROM products WHERE featured = 1 LIMIT 3";
$result = $conn->query($sql);

// Set the page title
$pageTitle = "Welcome to Forex EA Store";

// Include the header
include 'includes/header.php';
?>

<div class="jumbotron">
    <h1 class="display-4">Welcome to Forex EA Store</h1>
    <p class="lead">Discover high-performance Expert Advisors to elevate your Forex trading strategy.</p>
    <hr class="my-4">
    <p>Explore our collection of automated trading solutions designed to optimize your trading experience.</p>
    <a class="btn btn-primary btn-lg" href="products.php" role="button">View All Products</a>
</div>

<section class="featured-products my-5">
    <h2 class="text-center mb-4">Featured Expert Advisors</h2>
    <div class="row">
        <?php
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                ?>
                <div class="col-md-4 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php echo htmlspecialchars($row["name"]); ?></h5>
                            <p class="card-text"><?php echo htmlspecialchars(substr($row["description"], 0, 100)) . '...'; ?></p>
                            <p class="card-text"><strong>Price: $<?php echo number_format($row["price"], 2); ?></strong></p>
                            <a href="product-details.php?id=<?php echo $row["id"]; ?>" class="btn btn-primary">View Details</a>
                        </div>
                    </div>
                </div>
                <?php
            }
        } else {
            echo "<p class='text-center'>No featured products available at the moment.</p>";
        }
        ?>
    </div>
</section>

<section class="why-choose-us my-5">
    <h2 class="text-center mb-4">Why Choose Our Expert Advisors?</h2>
    <div class="row">
        <div class="col-md-4">
            <h3>High Performance</h3>
            <p>Our EAs are optimized for maximum efficiency and performance in various market conditions.</p>
        </div>
        <div class="col-md-4">
            <h3>Easy to Use</h3>
            <p>Simple installation and setup process, with detailed documentation for each Expert Advisor.</p>
        </div>
        <div class="col-md-4">
            <h3>Continuous Support</h3>
            <p>Our team provides ongoing support and updates to ensure your EA remains effective.</p>
        </div>
    </div>
</section>

<?php
// Close the database connection
$conn->close();

// Include the footer
include 'includes/footer.php';
?>