// Wait for the DOM to be fully loaded
document.addEventListener('DOMContentLoaded', function() {
    // Add to Cart button functionality
    const addToCartButtons = document.querySelectorAll('.add-to-cart');
    addToCartButtons.forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const productId = this.getAttribute('data-product-id');
            addToCart(productId);
        });
    });

    // Quantity input functionality in the cart
    const quantityInputs = document.querySelectorAll('.cart-quantity');
    quantityInputs.forEach(input => {
        input.addEventListener('change', function() {
            const productId = this.getAttribute('data-product-id');
            const newQuantity = this.value;
            updateCartQuantity(productId, newQuantity);
        });
    });

    // Form validation for the checkout page
    const checkoutForm = document.querySelector('#checkout-form');
    if (checkoutForm) {
        checkoutForm.addEventListener('submit', function(e) {
            if (!validateCheckoutForm()) {
                e.preventDefault();
            }
        });
    }
});

// Function to add a product to the cart
function addToCart(productId) {
    // Here you would typically make an AJAX call to your server
    // For this example, we'll just show an alert
    alert('Product added to cart!');
}

// Function to update the quantity of a product in the cart
function updateCartQuantity(productId, newQuantity) {
    // Here you would typically make an AJAX call to your server
    // For this example, we'll just show an alert
    alert(`Updated quantity for product ${productId} to ${newQuantity}`);
}

// Function to validate the checkout form
function validateCheckoutForm() {
    let isValid = true;
    const nameInput = document.querySelector('#name');
    const emailInput = document.querySelector('#email');
    const addressInput = document.querySelector('#address');

    if (!nameInput.value.trim()) {
        isValid = false;
        showError(nameInput, 'Name is required');
    }

    if (!emailInput.value.trim()) {
        isValid = false;
        showError(emailInput, 'Email is required');
    } else if (!isValidEmail(emailInput.value)) {
        isValid = false;
        showError(emailInput, 'Please enter a valid email address');
    }

    if (!addressInput.value.trim()) {
        isValid = false;
        showError(addressInput, 'Address is required');
    }

    return isValid;
}

// Function to show error messages
function showError(input, message) {
    const formGroup = input.closest('.form-group');
    const errorElement = formGroup.querySelector('.error-message') || document.createElement('div');
    errorElement.className = 'error-message text-danger';
    errorElement.textContent = message;
    formGroup.appendChild(errorElement);
}

// Function to validate email format
function isValidEmail(email) {
    const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(String(email).toLowerCase());
}